﻿# coding: UTF-8

from gpib import Gpib

#1秒でタイムアウト
Timeout_default_s = 1
Timeout_default_ms = 1000

def main():
    #Gpib通信クラスのインスタンス化
    gpib = Gpib()

    #接続
    print("BoardID?")
    boardID = input()
    print("PrimaryAddress?")
    primaryAddress = input()
    if not gpib.open(boardID, primaryAddress, Timeout_default_ms):
        return
    
    #コマンド送受信
    while True:
        print("Please enter the command (Exit with no input)")
        command = input()
        #入力なしで終了
        if command == "":
            break
        #「?」が含まれるので送受信
        if "?" in command :
            msgBuf = gpib.SendQueryMsg(command, Timeout_default_s)
            print(msgBuf) 
        #送信のみ
        else:
            gpib.sendMsg(command)
        
    gpib.close()

if __name__ == '__main__':
  main()
